breed [centers center]
breed [particles particle]

particles-own [
  fx     ;; x-sloka vektoru sly
  fy     ;; y-sloka vektoru sly
  vx     ;; x-sloka vektoru rychlosti
  vy     ;; y-sloka vektoru rychlosti
]

globals [
  r          ;; vzdlenost mezi stic a centrln stic
  potential  ;; potenciln energie stice
  force      ;; absolutn hodnota silovho vektoru
  previous-permitivita ;; posledn zaznamenan hodnota permitivity
  c-naboj   ;; nboj centrln stice
]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury tlatka PIPRAV ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  clear-all
  setup-plots
  set-default-shape turtles "circle"
  ask patches [ set pcolor background ]
  set previous-permitivita permitivita
  set c-naboj abs naboj
  create-centers 1 [
    set size 20
    set color gray
    hide-turtle
  ]
  create-particles 1 [
    set color blue
    set size 10
    fd random-float (max-pxcor - 6)
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury tlatka START ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to go
  if not any? particles [ stop ]
  ;; pidl stici odpovdajc nboj
  ask particles [ set label naboj ]
  ;; obarv polka barvou odpovdajc hodnot perimitivity
  ;; v ppad, e se zmn hodnota posuvnku "permitivita"
  if permitivita != previous-permitivita
  [
    ask patches [ set pcolor background ]
    set previous-permitivita permitivita
  ]
  set c-naboj abs naboj
  if mouse-down?
  [
    ask centers [ show-turtle ]
    every 0.1
    [
      ;; nate hodnotu pozice kurzoru myi
      let m-xc mouse-xcor
      let m-yc mouse-ycor
      ask centers
      [
        setxy m-xc m-yc
        set label c-naboj
      ]
      ask particles [
        update-force
        move
      ]
      ask particles [ calculate-potential-energy ]
      fade-patches
      tick
      if any? particles [ do-plots ]
    ]
  ]
end

to update-force  ;; procedura stic
  set r distance one-of centers
  ;; pokud je r = 0, dojde k zastaven bhu modelu
  ;; oetuje dlen nulou
  if r = 0 [ die ]
  ;; vypot slu pomoc zkona nepm zvislosti na tevrci vzdlenosti
  set force (- naboj) * c-naboj / (r ^ 2)
  ;; rozdl slu do x- a y-sloek
  face one-of centers
  set fx force * dx
  set fy force * dy
end

to move  ;; procedura stic
  ;; aktualizuje rychlost stice podle dosavadn 
  ;; rychlosti a nov dodan sly
  set vx vx + fx * permitivita
  set vy vy + fy * permitivita
  ;; stice zmiz pokud doshne okraje okna modelu
  if patch-at vx vy = nobody [ die ]
  ;; aktualizuje pozici stice
  setxy (xcor + vx) (ycor + vy)
  ;; opust drhu
  set pcolor background - 5
end

to calculate-potential-energy  ;; procedura stic
  set r distance one-of centers
  set potential naboj / r
end

;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Vizuln procedury ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

to-report background
  report permitivita * 8 + 5
end

to fade-patches
  ask patches with [pcolor != background] [
    set pcolor min list (pcolor + mira-slabnuti * 0.005) background
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;
;;; Procedury Graf ;;;
;;;;;;;;;;;;;;;;;;;;;;;

to setup-plots
  set-current-plot "Potenciln energie"
  set-current-plot "Vzdlenost (r)"
  set-current-plot "Coulombova sla"
end

to do-plots
  set-current-plot "Potenciln energie"
  set-current-plot-pen "potential"
  plot potential
  set-current-plot "Vzdlenost (r)"
  set-current-plot-pen "r"
  plot r
  set-current-plot "Coulombova sla"
  set-current-plot-pen "force"
  plot force
end


; *** NetLogo 4.0.3 Model Copyright Notice ***
;
; Copyright 2005 by Uri Wilensky.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Sengupta, P. and Wilensky, U. (2005). NetLogo Electrostatics model.
; http://ccl.northwestern.edu/netlogo/models/Electrostatics.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2005 Uri Wilensky.  All rights reserved.
; See http://ccl.northwestern.edu/netlogo/models/Electrostatics
; for terms of use.
;
; *** End of NetLogo 4.0.3 Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
208
10
720
543
125
125
2.0
1
18
1
1
1
0
0
0
1
-125
125
-125
125
1
1
1
ticks

CC-WINDOW
5
557
980
652
Command Center
0

BUTTON
9
40
95
73
Piprav
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
7
157
190
190
naboj
naboj
-8
8.0
-4
4
1
units
HORIZONTAL

BUTTON
104
40
190
73
Start
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL

SLIDER
754
502
944
535
mira-slabnuti
mira-slabnuti
0
100
40
5
1
%
HORIZONTAL

TEXTBOX
10
83
195
147
K ovldn kladnho elektrostatickho nboje zmknte a drte lev tlatko myi v prostoru hlavnho okna modelu (po stisknut tlatka START).
11
0.0
0

PLOT
723
194
971
344
Potenciln energie
as
potencil
0.0
10.0
0.0
1.0
true
true
PENS
"potential" 1.0 0 -16777216 false

SLIDER
7
191
190
224
permitivita
permitivita
1
9
9
2
1
units
HORIZONTAL

MONITOR
8
269
126
314
Coulombova sla
force
3
1
11

MONITOR
7
367
173
412
vzdlenost (r)
r
3
1
11

MONITOR
7
318
172
363
potenciln enegie
potential
3
1
11

PLOT
723
345
971
495
Vzdlenost (r)
as
vzdlenost
0.0
10.0
0.0
10.0
true
false
PENS
"r" 1.0 0 -16777216 true

PLOT
723
36
971
193
Coulombova sla
as
sla
0.0
10.0
0.0
0.05
true
false
PENS
"force" 1.0 0 -16777216 true

@#$#@#$#@
CO TO JE?
---------

Tento model popisuje bn prodn kaz vyjden Coulombovm zkonem. Ukazuje, co se stane, kdy se sla mezi dvma nboji inverzn mn s mocninou vzdlenosti mezi nimi. 

JAK TO FUNGUJE?
---------------

V tomto modelu se chovn kadho nboje d vzorcem Coulombova zkona:

F = (q1 * q2 * Permitivita) / (r^2)

V tomto vzorci: F znamen slu mezi dvma nboji q1 a q2; Permitivita, konstanta proporcionality, je vlastnost ltky (mdia), kter jsou nboje q1 a q2 umstny; r je vzdlenost mezi stedy obou nboj.

Tento model zohleduje pouze jednu slu mezi dvma sticemi, kde mme nboj q1 (modr stice, kter vznikne po stisknut tlatka PIPRAV) a proton (q2) (ed stice, kter se objev po stisknut levho tlatka myi v okn modelu). Sla je pouze jednosmrn - nboj q1 je pitahovn (nebo odpuzovn) smrem k protonu (q2), kter nen nijak ovlivnn. To je dno ist pro ely simulace. Ve skutenm svt psob Coulombova sla na vechny stice v okol.

Gravitace je dalm pkladem sly s nepmou zvislost na mocnin. I nae slunen soustava se piblin podob jdru (Slunce) s obhajcmi elektrony (planety).

Pro jist hodnoty q1 (kter lze ovldat pomoc posuvnku NABOJ) mete sledovat eliptick obn drhy kolem kurzoru myi (q2) nebo rychl odstediv prlet kolem q2, podobn prletm komet kolem naeho Slunce. Nboje q1 a q2 jsou vdy nastaveny na stejnou hodnotu, pestoe se mohou liit ve svm znamnku. 

JAK MODEL OVLDAT
-----------------

Po stisknut tlatka PIPRAV je vytvoen v modelu nboj q1 v prosted, jeho permitivita odpovd hodnot stejnojmennho posuvnku. Pokud stisknete a podrte lev tlatko myi kdekoliv v prostoru okna modelu, vytvote tm stici s kladnm nbojem (q2) na pozici kurzoru.

Posuvnk NABOJ ovld velikost nboje q1. Nejdve tedy vyberte potebnou hodnotu pro q1. (Pro ely jednoduchosti simulace je hodnota nboje q2 nastavena o jednotku vy. Toto nastaven tak ovlivuje vzdlenost, ve kter mohou stice bezpen obhat, ne jsou zcela vtaeny pitalivou silou.)

Posuvnk MIRA-SLABNUTI ovld rychlost, s jakou miz cesta, zobrazen za pohybujc se stic q1. Pi nastaven 100 % nebude vykreslena dn cesta (respektive okamit zmiz), pi nastaven 0 % cesta nebude mizet vbec.

Posuvnk PERMITIVITA umouje zmnit hodnotu konstanty proporcionality ve vzorci Coulombova zkona. Na em je tato promnn zvisl? Na nbojch nebo na ltce, kter tvo prosted, ve kterm jsou oba nboje umstny?

Po nastaven posuvnk na poadovan hodnoty stisknte START, kterm simulaci spustte. Pemstte kurzor myi na msto, kde chcete, aby se objevil nboj q2. Na tomto mst kliknte a drte tlatko myi. Tm rozpohybujete stice. Pokud chcete zastavit simulaci (napklad abyste zmnili hodnotu parametru NABOJ), puste lev tlatko myi a stice se pestanou pohybovat. Pot mete libovoln zmnit nastaven posuvnk. Pro pokraovn simulace opt umstte kurzor myi do prostoru okna modelu a opt stisknte. Veker objekty v okn se pohybuj pouze pi stisknut tlatka myi. 

VIMNTE SI
-----------

Nejdleitjm faktorem, kter lze v modelu pozorovat, je chovn q1 (modr nboj).

Jak je poten rychlost q1?

Co se stane, pokud zmnte hodnotu q1 ze zporn na kladnou hodnotu?

V prbhu simulace sledujte grafy, umstn napravo od hlavnho okna modelu. Co lze z grafu vyst o vztahu mezi potenciln energi a vzdlenosti obou nboj? Co mete ci o vztahu mezi Coulombovou silou a vzdlenost mezi nboji?

Pohybujte kurzorem v prostoru okna modelu - sledujte, co se stane, pokud pohybujete my rychle, nebo naopak pomalu. Zkuste tak oscilovat kurzorem kolem jedinho msta nebo jm zcela pestate pohybovat. Pozorujte, jakmi drhami se stice pohybuj. (Pro lep nzornost mete nastavit parametr MIRA-SLABNUTI na dostaten nzkou hodnotu.) 

VYZKOUEJTE SI
--------------

Zkuste spustit simulaci s rznmi hodnotami: a) nboje - sledujte peliv, jak rzn hodnoty posuvnku NABOJ ovlivn model pi zachovn stejn hodnoty permitivity; b) permitivity - sledujte peliv, jak rzn hodnoty posuvnku PERMITIVITA ovlivn model pi zachovn stejn hodnoty nboje.

Dokete zadit, aby q1 obhalo kolem q2? Pedstavte si, e pokud by byla stice q1 elektron a q2 proton, pak jste prv vytvoili atom vodku...

V prbhu simulace mete sbrat data o tom, jak: a) se sla mezi dvma nboji mn s jejich vzjemnou vzdlenost; b) se mn potenciln energie se vzdlenost mezi nboji; c) sla zvis na permitivit prosted.

Pro kad z tchto ppad opakujte pokus 8x a 10x. Zapisujte si run nebo pomoc vhodnho zobrazovacho programu namen vsledky. 

ROZEN MODELU
----------------

Urete protonu (q2) fixn pozici v modelu - vytvote ho tak nezvislm na pozici kurzoru myi. Piate promnnou jeho hodnot.

Nyn vytvote dal nboj (z rodu centres) a piate mu tak pevn danou pozici v grafickm okn modelu. Spoutjte model pro rzn hodnoty pozic, nboje a znamnka (+, -) novho centra.

Vytvote si vce testovacch nboj. Pot umstte dv centra s opanmi znamnky a srovnatelnmi hodnotami nboje pobl obou horizontlnch hranic modelovho svta. Spuste model. Co se stane? 

SOUVISEJC MODELY
------------------

Gravitace (gravitace) 

PROGRAMOVAC ZAJMAVOSTI NETLOGA
--------------------------------

Pokud se stice svm pohybem dostane za hranice okna modelu, neobjev se na obrcen stran (tak jako ve vtin model v NetLogu). Bh simulace se zastav, pokud stice opust prostor okna modelu.

PODKOVN A ODKAZY
----------------------
Tento model vznikl jako soust studijnho programu NIELS. Program NIELS je rozvjen na institutu Northwestern's Center for Connected Learning and Computer-Based Modeling. Vce informac o programu NIELS naleznete na http://ccl.northwestern.edu/NIELS. 

Pi citovn tohoto modelu ve vdeckch publikacch pouijte prosm nsledujc odkaz:  Sengupta, P. and Wilensky, U. (2005).  NetLogo Electrostatics model.  http://ccl.northwestern.edu/netlogo/models/Electrostatics.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

V jinch publikacch uvete prosm tyto informace:  Copyright 2005 Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/Electrostatics for terms of use.
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 4.0.3
@#$#@#$#@
need-to-manually-make-preview-for-this-model
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180

@#$#@#$#@
